<?xml version="1.0"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:dir="http://apache.org/cocoon/directory/2.0">

   <xsl:import href="../docbook-xsl-1.65.1/xhtml/docbook.xsl" />
   
   <xsl:param name="cssfile"/>
   <xsl:param name="path"/>
   
   <xsl:template match="page">
      <html>
        <head>
		   <link rel="stylesheet" href="{$cssfile}" type="text/css"/>
           <title>INJAC</title>           
        </head>
		<body>
            <xsl:apply-templates/>
            <a href="../?cssfile={$cssfile}"><i>retour</i></a>
        </body>
        
      </html>
   </xsl:template>
   
   <xsl:template match="styleCss">
	  <div id="listeCSS">
         <form >
            <select name="stylesheetList" onChange="alert(' INDISPONIBLE pour le moment ')">
               <xsl:apply-templates select="cssName" />
            </select>
         </form>
      </div>
   </xsl:template>

   <xsl:template match="cssName">
      <option value="{.}">
         <xsl:value-of select="." />
      </option>
   </xsl:template>
   
   <xsl:template match="dirgen">
      <div id="leftMenu">
      	<ul type="disc" id="currentFolder">
         <xsl:apply-templates />
		</ul>
      </div>
   </xsl:template>

   <xsl:template match="current">
      
      <li id="currentName"><xsl:value-of select="name" /></li>
		
   </xsl:template>

   <xsl:template match="directory">
   
      <li class="directory">
		<a href="./{name}/?cssfile={$cssfile}&amp;path={$path}/{name}">
			<xsl:value-of select="name" />
		</a>    
        <ul type="circle">
			<li id="directoryDate"><xsl:value-of select="date" /></li>
			<li id="directorySize"><xsl:value-of select="size" /></li>
		</ul>
      </li>
   </xsl:template>

   <xsl:template match="file">
      
	  <li class="file">
		<a href="./{name}?cssfile={$cssfile}">
			<xsl:value-of select="name" />
		</a>
        <ul type="circle">
			<li id="fileDate"><xsl:value-of select="date" /></li>
			<li id="fileSize"><xsl:value-of select="size" /></li>
		</ul>
      </li>
      
   </xsl:template>
   
   <xsl:template match="article">
   		 <div id="docbookDocument">
   		 	<xsl:apply-imports/>
         </div>
   </xsl:template>      

</xsl:stylesheet>

